#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timers 4 and 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/*******************************************************************
*    Function Name:  ConfigIntTimer45                              *
*    Description:    This Function Configures Interrupt and sets   *
*                    Interrupt Priority                            *
*    Parameters:     unsigned int config                           *               
*    Return Value:   None                                          *
*******************************************************************/

void ConfigIntTimer45(unsigned int config)
{
    IFS1bits.T5IF = 0;                   /* clear IF bit */
    IPC5bits.T5IP = (config &0x0007);    /* assigning Interrupt Priority */
    IEC1bits.T5IE = (config &0x0008)>>3; /* Interrupt Enable /Disable */
}

#endif
